package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RowLevelSecurityStatistics(
    // [Output-only] [Preview] Whether any accessed data was protected by row access policies.
    rowLevelSecurityApplied: Option[Boolean] = None
)
object RowLevelSecurityStatistics {
  implicit val encoder: Encoder[
    RowLevelSecurityStatistics
  ] = Encoder.instance { x =>
    Json.obj("rowLevelSecurityApplied" := x.rowLevelSecurityApplied)
  }
  implicit val decoder: Decoder[
    RowLevelSecurityStatistics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("rowLevelSecurityApplied")
    } yield RowLevelSecurityStatistics(v0)
  }
}
