package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RowAccessPolicyReference(
    // Required. The ID of the dataset containing this row access policy.
    datasetId: Option[String] = None,
    // Required. The ID of the row access policy. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
    policyId: Option[String] = None,
    // Required. The ID of the project containing this row access policy.
    projectId: Option[String] = None,
    // Required. The ID of the table containing this row access policy.
    tableId: Option[String] = None,
)
object RowAccessPolicyReference {
  implicit val encoder: Encoder[
    RowAccessPolicyReference
  ] = Encoder.instance { x =>
    Json.obj(
      "datasetId" := x.datasetId,
      "policyId" := x.policyId,
      "projectId" := x.projectId,
      "tableId" := x.tableId,
    )
  }
  implicit val decoder: Decoder[
    RowAccessPolicyReference
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("datasetId")
      v1 <- c.get[Option[String]]("policyId")
      v2 <- c.get[Option[String]]("projectId")
      v3 <- c.get[Option[String]]("tableId")
    } yield RowAccessPolicyReference(v0, v1, v2, v3)
  }
}
