package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RowAccessPolicy( // Output only. A hash of this resource.
    etag: Option[String] =
      None, // Output only. The time when this row access policy was last modified, in milliseconds since the epoch.
    lastModifiedTime: Option[String] =
      None, // Required. Reference describing the ID of this row access policy.
    rowAccessPolicyReference: Option[RowAccessPolicyReference] =
      None, // Required. A SQL boolean expression that represents the rows defined by this row access policy, similar to the boolean expression in a WHERE clause of a SELECT query on a table. References to other tables, routines, and temporary functions are not supported. Examples: region="EU" date_field = CAST('2019-9-27' as DATE) nullable_field is not NULL numeric_field BETWEEN 1.0 AND 5.0
    filterPredicate: Option[String] =
      None, // Output only. The time when this row access policy was created, in milliseconds since the epoch.
    creationTime: Option[String] = None,
)
object RowAccessPolicy {
  implicit val encoder: Encoder[RowAccessPolicy] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "lastModifiedTime" := x.lastModifiedTime,
      "rowAccessPolicyReference" := x.rowAccessPolicyReference,
      "filterPredicate" := x.filterPredicate,
      "creationTime" := x.creationTime,
    )
  }
  implicit val decoder: Decoder[RowAccessPolicy] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[String]]("lastModifiedTime")
      v2 <- c.get[Option[RowAccessPolicyReference]]("rowAccessPolicyReference")
      v3 <- c.get[Option[String]]("filterPredicate")
      v4 <- c.get[Option[String]]("creationTime")
    } yield RowAccessPolicy(v0, v1, v2, v3, v4)
  }
}
