package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class Row( // The original label of this row.
    actualLabel: Option[String] = None, // Info describing predicted label distribution.
    entries: Option[List[Entry]] = None,
)
object Row {
  implicit val encoder: Encoder[Row] = Encoder.instance { x =>
    Json.obj("actualLabel" := x.actualLabel, "entries" := x.entries)
  }
  implicit val decoder: Decoder[Row] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("actualLabel")
      v1 <- c.get[Option[List[Entry]]]("entries")
    } yield Row(v0, v1)
  }
}
