package googleapis.bigquery

import io.circe._

sealed abstract class RoutineSecurityMode(val value: String) extends Product with Serializable
object RoutineSecurityMode {
  // The security mode of the routine is unspecified.
  case object SECURITY_MODE_UNSPECIFIED extends RoutineSecurityMode("SECURITY_MODE_UNSPECIFIED")
  // The routine is to be executed with the privileges of the user who defines it.
  case object DEFINER extends RoutineSecurityMode("DEFINER")
  // The routine is to be executed with the privileges of the user who invokes it.
  case object INVOKER extends RoutineSecurityMode("INVOKER")
  val values = List(SECURITY_MODE_UNSPECIFIED, DEFINER, INVOKER)
  def fromString(input: String): Either[String, RoutineSecurityMode] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for RoutineSecurityMode")
  implicit val decoder: Decoder[RoutineSecurityMode] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[RoutineSecurityMode] = Encoder[String].contramap(_.value)
}
