package googleapis.bigquery

import io.circe._

sealed abstract class RoutineRoutineType(val value: String) extends Product with Serializable
object RoutineRoutineType {
  // Default value.
  case object ROUTINE_TYPE_UNSPECIFIED extends RoutineRoutineType("ROUTINE_TYPE_UNSPECIFIED")
  // Non-built-in persistent scalar function.
  case object SCALAR_FUNCTION extends RoutineRoutineType("SCALAR_FUNCTION")
  // Stored procedure.
  case object PROCEDURE extends RoutineRoutineType("PROCEDURE")
  // Non-built-in persistent TVF.
  case object TABLE_VALUED_FUNCTION extends RoutineRoutineType("TABLE_VALUED_FUNCTION")
  // Non-built-in persistent aggregate function.
  case object AGGREGATE_FUNCTION extends RoutineRoutineType("AGGREGATE_FUNCTION")
  val values = List(
    ROUTINE_TYPE_UNSPECIFIED,
    SCALAR_FUNCTION,
    PROCEDURE,
    TABLE_VALUED_FUNCTION,
    AGGREGATE_FUNCTION,
  )
  def fromString(input: String): Either[String, RoutineRoutineType] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for RoutineRoutineType")
  implicit val decoder: Decoder[RoutineRoutineType] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[RoutineRoutineType] = Encoder[String].contramap(_.value)
}
