package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RoutineReference(
    // Required. The ID of the dataset containing this routine.
    datasetId: Option[String] = None,
    // Required. The ID of the project containing this routine.
    projectId: Option[String] = None,
    // Required. The ID of the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
    routineId: Option[String] = None,
)
object RoutineReference {
  implicit val encoder: Encoder[RoutineReference] = Encoder.instance { x =>
    Json.obj(
      "datasetId" := x.datasetId,
      "projectId" := x.projectId,
      "routineId" := x.routineId,
    )
  }
  implicit val decoder: Decoder[RoutineReference] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("datasetId")
      v1 <- c.get[Option[String]]("projectId")
      v2 <- c.get[Option[String]]("routineId")
    } yield RoutineReference(v0, v1, v2)
  }
}
