package googleapis.bigquery

import io.circe._

sealed abstract class RoutineLanguage(val value: String) extends Product with Serializable
object RoutineLanguage {
  // Default value.
  case object LANGUAGE_UNSPECIFIED extends RoutineLanguage("LANGUAGE_UNSPECIFIED")
  // SQL language.
  case object SQL extends RoutineLanguage("SQL")
  // JavaScript language.
  case object JAVASCRIPT extends RoutineLanguage("JAVASCRIPT")
  // Python language.
  case object PYTHON extends RoutineLanguage("PYTHON")
  // Java language.
  case object JAVA extends RoutineLanguage("JAVA")
  // Scala language.
  case object SCALA extends RoutineLanguage("SCALA")
  val values = List(LANGUAGE_UNSPECIFIED, SQL, JAVASCRIPT, PYTHON, JAVA, SCALA)
  def fromString(input: String): Either[String, RoutineLanguage] =
    values.find(_.value == input).toRight(s"'$input' was not a valid value for RoutineLanguage")
  implicit val decoder: Decoder[RoutineLanguage] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[RoutineLanguage] = Encoder[String].contramap(_.value)
}
