package googleapis.bigquery

import io.circe._

sealed abstract class RoutineDeterminismLevel(val value: String) extends Product with Serializable
object RoutineDeterminismLevel {
  // The determinism of the UDF is unspecified.
  case object DETERMINISM_LEVEL_UNSPECIFIED
      extends RoutineDeterminismLevel("DETERMINISM_LEVEL_UNSPECIFIED")
  // The UDF is deterministic, meaning that 2 function calls with the same inputs always produce the same result, even across 2 query runs.
  case object DETERMINISTIC extends RoutineDeterminismLevel("DETERMINISTIC")
  // The UDF is not deterministic.
  case object NOT_DETERMINISTIC extends RoutineDeterminismLevel("NOT_DETERMINISTIC")
  val values = List(DETERMINISM_LEVEL_UNSPECIFIED, DETERMINISTIC, NOT_DETERMINISTIC)
  def fromString(input: String): Either[String, RoutineDeterminismLevel] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for RoutineDeterminismLevel")
  implicit val decoder: Decoder[RoutineDeterminismLevel] = Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[RoutineDeterminismLevel] = Encoder[String].contramap(_.value)
}
