package googleapis.bigquery

import io.circe._

sealed abstract class RoutineDataGovernanceType(val value: String) extends Product with Serializable
object RoutineDataGovernanceType {
  // The data governance type is unspecified.
  case object DATA_GOVERNANCE_TYPE_UNSPECIFIED
      extends RoutineDataGovernanceType("DATA_GOVERNANCE_TYPE_UNSPECIFIED")
  // The data governance type is data masking.
  case object DATA_MASKING extends RoutineDataGovernanceType("DATA_MASKING")
  val values = List(DATA_GOVERNANCE_TYPE_UNSPECIFIED, DATA_MASKING)
  def fromString(input: String): Either[String, RoutineDataGovernanceType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for RoutineDataGovernanceType")
  implicit val decoder: Decoder[RoutineDataGovernanceType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[RoutineDataGovernanceType] = Encoder[String].contramap(_.value)
}
