package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class Routine( // Output only. A hash of this resource.
    etag: Option[String] =
      None, // Output only. The time when this routine was last modified, in milliseconds since the epoch.
    lastModifiedTime: Option[FiniteDuration] =
      None, // Optional. The description of the routine, if defined.
    description: Option[String] =
      None, // Optional. Can be set only if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return table type is inferred from definition_body at query time in each query that references this routine. If present, then the columns in the evaluated table result will be cast to match the column types specified in return table type, at query time.
    returnTableType: Option[StandardSqlTableType] = None, // Required. The type of routine.
    routineType: Option[RoutineRoutineType] =
      None, // Required. The body of the routine. For functions, this is the expression in the AS clause. If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for the function created with the following statement: `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\n", y))` The definition_body is `concat(x, "\n", y)` (\n is not replaced with linebreak). If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the function created with the following statement: `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\n";\n'` The definition_body is `return "\n";\n` Note that both \n are replaced with linebreaks.
    definitionBody: Option[String] =
      None, // Optional. Defaults to "SQL" if remote_function_options field is absent, not set otherwise.
    language: Option[RoutineLanguage] =
      None, // Optional. Use this option to catch many common errors. Error checking is not exhaustive, and successfully creating a procedure doesn't guarantee that the procedure will successfully execute at runtime. If `strictMode` is set to `TRUE`, the procedure body is further checked for errors such as non-existent tables or columns. The `CREATE PROCEDURE` statement fails if the body fails any of these checks. If `strictMode` is set to `FALSE`, the procedure body is checked only for syntax. For procedures that invoke themselves recursively, specify `strictMode=FALSE` to avoid non-existent procedure errors during validation. Default value is `TRUE`.
    strictMode: Option[Boolean] =
      None, // Optional if language = "SQL"; required otherwise. Cannot be set if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return type is inferred from definition_body at query time in each query that references this routine. If present, then the evaluated result will be cast to the specified returned type at query time. For example, for the functions created with the following statements: * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);` * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));` * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));` The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for `Increment` (inferred as FLOAT64 at query time). Suppose the function `Add` is replaced by `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64) AS (x + y);` Then the inferred return type of `Increment` is automatically changed to INT64 at query time, while the return type of `Decrement` remains FLOAT64.
    returnType: Option[StandardSqlDataType] =
      None, // Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT libraries.
    importedLibraries: Option[List[String]] =
      None, // Required. Reference describing the ID of this routine.
    routineReference: Option[RoutineReference] = None, // Optional. Spark specific options.
    sparkOptions: Option[SparkOptions] =
      None, // Optional. If set to `DATA_MASKING`, the function is validated and made available as a masking function. For more information, see [Create custom masking routines](https://cloud.google.com/bigquery/docs/user-defined-functions#custom-mask).
    dataGovernanceType: Option[RoutineDataGovernanceType] =
      None, // Optional. The determinism level of the JavaScript UDF, if defined.
    determinismLevel: Option[RoutineDeterminismLevel] =
      None, // Optional. Remote function specific options.
    remoteFunctionOptions: Option[RemoteFunctionOptions] =
      None, // Optional. The security mode of the routine, if defined. If not defined, the security mode is automatically determined from the routine's configuration.
    securityMode: Option[RoutineSecurityMode] =
      None, // Output only. The time when this routine was created, in milliseconds since the epoch.
    creationTime: Option[FiniteDuration] = None, // Optional.
    arguments: Option[List[Argument]] = None,
)
object Routine {
  implicit val encoder: Encoder[Routine] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "lastModifiedTime" := x.lastModifiedTime,
      "description"
        := x.description,
      "returnTableType" := x.returnTableType,
      "routineType" :=
        x.routineType,
      "definitionBody" := x.definitionBody,
      "language" := x.language,
      "strictMode" := x.strictMode,
      "returnType" := x.returnType,
      "importedLibraries" := x.importedLibraries,
      "routineReference" := x.routineReference,
      "sparkOptions" := x.sparkOptions,
      "dataGovernanceType"
        := x.dataGovernanceType,
      "determinismLevel" := x.determinismLevel,
      "remoteFunctionOptions" := x.remoteFunctionOptions,
      "securityMode" := x.securityMode,
      "creationTime" := x.creationTime,
      "arguments" := x.arguments,
    )
  }
  implicit val decoder: Decoder[Routine] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[FiniteDuration]]("lastModifiedTime")
      v2 <- c.get[Option[String]]("description")
      v3 <- c.get[Option[StandardSqlTableType]]("returnTableType")
      v4 <- c.get[Option[RoutineRoutineType]]("routineType")
      v5 <- c.get[Option[String]]("definitionBody")
      v6 <- c.get[Option[RoutineLanguage]]("language")
      v7 <- c.get[Option[Boolean]]("strictMode")
      v8 <- c.get[Option[StandardSqlDataType]]("returnType")
      v9 <- c.get[Option[List[String]]]("importedLibraries")
      v10 <- c.get[Option[RoutineReference]]("routineReference")
      v11 <- c.get[Option[SparkOptions]]("sparkOptions")
      v12 <- c.get[Option[RoutineDataGovernanceType]]("dataGovernanceType")
      v13 <- c.get[Option[RoutineDeterminismLevel]]("determinismLevel")
      v14 <- c.get[Option[RemoteFunctionOptions]]("remoteFunctionOptions")
      v15 <- c.get[Option[RoutineSecurityMode]]("securityMode")
      v16 <- c.get[Option[FiniteDuration]]("creationTime")
      v17 <- c.get[Option[List[Argument]]]("arguments")
    } yield Routine(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12, v13, v14, v15, v16, v17)
  }
}
