package googleapis.bigquery

import io.circe._

sealed abstract class RemoteModelInfoRemoteServiceType(val value: String)
    extends Product
    with Serializable
object RemoteModelInfoRemoteServiceType {
  // Unspecified remote service type.
  case object REMOTE_SERVICE_TYPE_UNSPECIFIED
      extends RemoteModelInfoRemoteServiceType("REMOTE_SERVICE_TYPE_UNSPECIFIED")
  // V3 Cloud AI Translation API. See more details at [Cloud Translation API] (https://cloud.google.com/translate/docs/reference/rest).
  case object CLOUD_AI_TRANSLATE_V3
      extends RemoteModelInfoRemoteServiceType("CLOUD_AI_TRANSLATE_V3")
  // V1 Cloud AI Vision API See more details at [Cloud Vision API] (https://cloud.google.com/vision/docs/reference/rest).
  case object CLOUD_AI_VISION_V1 extends RemoteModelInfoRemoteServiceType("CLOUD_AI_VISION_V1")
  // V1 Cloud AI Natural Language API. See more details at [REST Resource: documents](https://cloud.google.com/natural-language/docs/reference/rest/v1/documents).
  case object CLOUD_AI_NATURAL_LANGUAGE_V1
      extends RemoteModelInfoRemoteServiceType("CLOUD_AI_NATURAL_LANGUAGE_V1")
  // V2 Speech-to-Text API. See more details at [Google Cloud Speech-to-Text V2 API](https://cloud.google.com/speech-to-text/v2/docs)
  case object CLOUD_AI_SPEECH_TO_TEXT_V2
      extends RemoteModelInfoRemoteServiceType("CLOUD_AI_SPEECH_TO_TEXT_V2")
  val values = List(
    REMOTE_SERVICE_TYPE_UNSPECIFIED,
    CLOUD_AI_TRANSLATE_V3,
    CLOUD_AI_VISION_V1,
    CLOUD_AI_NATURAL_LANGUAGE_V1,
    CLOUD_AI_SPEECH_TO_TEXT_V2,
  )
  def fromString(input: String): Either[String, RemoteModelInfoRemoteServiceType] = values
    .find(_.value == input)
    .toRight(s"'$input' was not a valid value for RemoteModelInfoRemoteServiceType")
  implicit val decoder: Decoder[RemoteModelInfoRemoteServiceType] =
    Decoder[String].emap(s => fromString(s))
  implicit val encoder: Encoder[RemoteModelInfoRemoteServiceType] =
    Encoder[String].contramap(_.value)
}
