package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RemoteModelInfo(
    // Output only. The name of the speech recognizer to use for speech recognition. The expected format is `projects/{project}/locations/{location}/recognizers/{recognizer}`. Customers can specify this field at model creation. If not specified, a default recognizer `projects/{model project}/locations/global/recognizers/_` will be used. See more details at [recognizers](https://cloud.google.com/speech-to-text/v2/docs/reference/rest/v2/projects.locations.recognizers)
    speechRecognizer: Option[String] = None,
    // Output only. The model version for LLM.
    remoteModelVersion: Option[String] = None,
    // Output only. The endpoint for remote model.
    endpoint: Option[String] = None,
    // Output only. Fully qualified name of the user-provided connection object of the remote model. Format: ```"projects/{project_id}/locations/{location_id}/connections/{connection_id}"```
    connection: Option[String] = None,
    // Output only. Max number of rows in each batch sent to the remote service. If unset, the number of rows in each batch is set dynamically.
    maxBatchingRows: Option[Long] = None,
    // Output only. The remote service type for remote model.
    remoteServiceType: Option[RemoteModelInfoRemoteServiceType] = None,
)
object RemoteModelInfo {
  implicit val encoder: Encoder[RemoteModelInfo] = Encoder.instance { x =>
    Json.obj(
      "speechRecognizer" := x.speechRecognizer,
      "remoteModelVersion" := x.remoteModelVersion,
      "endpoint" := x.endpoint,
      "connection" := x.connection,
      "maxBatchingRows" := x.maxBatchingRows,
      "remoteServiceType" :=
        x.remoteServiceType,
    )
  }
  implicit val decoder: Decoder[RemoteModelInfo] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("speechRecognizer")
      v1 <- c.get[Option[String]]("remoteModelVersion")
      v2 <- c.get[Option[String]]("endpoint")
      v3 <- c.get[Option[String]]("connection")
      v4 <- c.get[Option[Long]]("maxBatchingRows")
      v5 <- c.get[Option[RemoteModelInfoRemoteServiceType]]("remoteServiceType")
    } yield RemoteModelInfo(v0, v1, v2, v3, v4, v5)
  }
}
