package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RemoteFunctionOptions(
    // Fully qualified name of the user-provided connection object which holds the authentication information to send requests to the remote service. Format: ```"projects/{projectId}/locations/{locationId}/connections/{connectionId}"```
    connection: Option[String] = None,
    // Endpoint of the user-provided remote service, e.g. ```https://us-east1-my_gcf_project.cloudfunctions.net/remote_add```
    endpoint: Option[String] = None,
    // Max number of rows in each batch sent to the remote service. If absent or if 0, BigQuery dynamically decides the number of rows in a batch.
    maxBatchingRows: Option[Long] = None,
    // User-defined context as a set of key/value pairs, which will be sent as function invocation context together with batched arguments in the requests to the remote service. The total number of bytes of keys and values must be less than 8KB.
    userDefinedContext: Option[Map[String, String]] = None,
)
object RemoteFunctionOptions {
  implicit val encoder: Encoder[RemoteFunctionOptions] = Encoder.instance { x =>
    Json.obj(
      "connection" := x.connection,
      "endpoint" := x.endpoint,
      "maxBatchingRows"
        := x.maxBatchingRows,
      "userDefinedContext" := x.userDefinedContext,
    )
  }
  implicit val decoder: Decoder[RemoteFunctionOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("connection")
      v1 <- c.get[Option[String]]("endpoint")
      v2 <- c.get[Option[Long]]("maxBatchingRows")
      v3 <- c.get[Option[Map[String, String]]]("userDefinedContext")
    } yield RemoteFunctionOptions(v0, v1, v2, v3)

  }
}
