package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RegressionMetrics( // Mean squared error.
    meanSquaredError: Option[Double] =
      None, // R^2 score. This corresponds to r2_score in ML.EVALUATE.
    rSquared: Option[Double] = None, // Median absolute error.
    medianAbsoluteError: Option[Double] = None, // Mean absolute error.
    meanAbsoluteError: Option[Double] = None, // Mean squared log error.
    meanSquaredLogError: Option[Double] = None,
)
object RegressionMetrics {
  implicit val encoder: Encoder[RegressionMetrics] = Encoder.instance { x =>
    Json.obj(
      "meanSquaredError" := x.meanSquaredError,
      "rSquared" := x.rSquared,
      "medianAbsoluteError" := x.medianAbsoluteError,
      "meanAbsoluteError" := x.meanAbsoluteError,
      "meanSquaredLogError" := x.meanSquaredLogError,
    )
  }
  implicit val decoder: Decoder[RegressionMetrics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("meanSquaredError")
      v1 <- c.get[Option[Double]]("rSquared")
      v2 <- c.get[Option[Double]]("medianAbsoluteError")
      v3 <- c.get[Option[Double]]("meanAbsoluteError")
      v4 <- c.get[Option[Double]]("meanSquaredLogError")
    } yield RegressionMetrics(v0, v1, v2, v3, v4)

  }
}
