package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RangeValue(
    // Optional. The end value of the range. A missing value represents an unbounded end.
    end: Option[QueryParameterValue] = None,
    // Optional. The start value of the range. A missing value represents an unbounded start.
    start: Option[QueryParameterValue] = None,
)
object RangeValue {
  implicit val encoder: Encoder[RangeValue] = Encoder.instance { x =>
    Json.obj("end" := x.end, "start" := x.start)
  }
  implicit val decoder: Decoder[RangeValue] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[QueryParameterValue]]("end")
      v1 <- c.get[Option[QueryParameterValue]]("start")
    } yield RangeValue(v0, v1)
  }
}
