package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RangePartitioningRange(
    // [TrustedTester] [Required] The end of range partitioning, exclusive.
    end: Long, // [TrustedTester] [Required] The width of each interval.
    interval: Long,
    // [TrustedTester] [Required] The start of range partitioning, inclusive.
    start: Long,
)
object RangePartitioningRange {
  implicit val encoder: Encoder[RangePartitioningRange] = Encoder.instance { x =>
    Json.obj("end" := x.end, "interval" := x.interval, "start" := x.start)
  }
  implicit val decoder: Decoder[
    RangePartitioningRange
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Long]("end")
      v1 <- c.get[Long]("interval")
      v2 <- c.get[Long]("start")
    } yield RangePartitioningRange(v0, v1, v2)
  }
}
