package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class RangePartitioning(
    // [TrustedTester] [Required] The table is partitioned by this field. The field must be a top-level NULLABLE/REQUIRED field. The only supported type is INTEGER/INT64.
    field: String,
    // [TrustedTester] [Required] Defines the ranges for range partitioning.
    range: RangePartitioningRange,
)
object RangePartitioning {
  implicit val encoder: Encoder[RangePartitioning] = Encoder.instance { x =>
    Json.obj("field" := x.field, "range" := x.range)
  }
  implicit val decoder: Decoder[RangePartitioning] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("field")
      v1 <- c.get[RangePartitioningRange]("range")
    } yield RangePartitioning(v0, v1)

  }
}
