package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryTimelineSample(
    // Units of work that can be scheduled immediately. Providing additional slots for these units of work will speed up the query, provided no other query in the reservation needs additional slots.
    estimatedRunnableUnits: Option[Long] = None,
    // Total units of work remaining for the query. This number can be revised (increased or decreased) while the query is running.
    pendingUnits: Option[Long] = None,
    // Total parallel units of work completed by this query.
    completedUnits: Option[Long] = None,
    // Total number of units currently being processed by workers. This does not correspond directly to slot usage. This is the largest value observed since the last sample.
    activeUnits: Option[Long] = None, // Cumulative slot-ms consumed by the query.
    totalSlotMs: Option[Long] = None,
    // Milliseconds elapsed since the start of query execution.
    elapsedMs: Option[Long] = None,
)
object QueryTimelineSample {
  implicit val encoder: Encoder[QueryTimelineSample] = Encoder.instance { x =>
    Json.obj(
      "estimatedRunnableUnits" := x.estimatedRunnableUnits,
      "pendingUnits" := x.pendingUnits,
      "completedUnits" := x.completedUnits,
      "activeUnits" := x.activeUnits,
      "totalSlotMs" := x.totalSlotMs,
      "elapsedMs" := x.elapsedMs,
    )
  }
  implicit val decoder: Decoder[QueryTimelineSample] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("estimatedRunnableUnits")
      v1 <- c.get[Option[Long]]("pendingUnits")
      v2 <- c.get[Option[Long]]("completedUnits")
      v3 <- c.get[Option[Long]]("activeUnits")
      v4 <- c.get[Option[Long]]("totalSlotMs")
      v5 <- c.get[Option[Long]]("elapsedMs")
    } yield QueryTimelineSample(v0, v1, v2, v3, v4, v5)

  }
}
