package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryResponse(
    // Query ID for the completed query. This ID will be auto-generated. This field is not yet available and it is currently not guaranteed to be populated.
    queryId: Option[String] = None,
    // The total number of bytes processed for this query. If this query was a dry run, this is the number of bytes that would be processed if the query were run.
    totalBytesProcessed: Option[Long] = None,
    // Whether the query result was fetched from the query cache.
    cacheHit: Option[Boolean] = None,
    // [Output-only] [Preview] Information of the session if this job is part of one.
    sessionInfo: Option[SessionInfo] = None,
    // [Output-only] The first errors or warnings encountered during the running of the job. The final message includes the number of errors that caused the process to stop. Errors here do not necessarily mean that the job has completed or was unsuccessful.
    errors: Option[List[ErrorProto]] = None, // A token used for paging results.
    pageToken: Option[String] = None,
    // Optional. Only relevant when a job_reference is present in the response. If job_reference is not present it will always be unset. When job_reference is present, this field should be interpreted as follows: If set, it will provide the reason of why a Job was created. If not set, it should be treated as the default: REQUESTED. This feature is not yet available. Jobs will always be created.
    jobCreationReason: Option[Json] = None,
    // Whether the query has completed or not. If rows or totalRows are present, this will always be true. If this is false, totalRows will not be available.
    jobComplete: Option[Boolean] = None,
    // The schema of the results. Present only when the query completes successfully.
    schema: Option[TableSchema] = None,
    // [Output-only] Detailed statistics for DML statements Present only for DML statements INSERT, UPDATE, DELETE or TRUNCATE.
    dmlStats: Option[DmlStatistics] = None,
    // [Output-only] The number of rows affected by a DML statement. Present only for DML statements INSERT, UPDATE or DELETE.
    numDmlAffectedRows: Option[Long] = None,
    // The total number of rows in the complete query result set, which can be more than the number of rows in this single page of results.
    totalRows: Option[BigInt] = None, // The resource type.
    kind: Option[String] = None,
    // Reference to the Job that was created to run the query. This field will be present even if the original request timed out, in which case GetQueryResults can be used to read the results once the query has completed. Since this API only returns the first page of results, subsequent pages can be fetched via the same mechanism (GetQueryResults).
    jobReference: Option[JobReference] = None,
    // An object with as many results as can be contained within the maximum permitted reply size. To get any additional rows, you can call GetQueryResults and specify the jobReference returned above.
    rows: Option[List[TableRow]] = None,
)
object QueryResponse {
  implicit val encoder: Encoder[QueryResponse] = Encoder.instance { x =>
    Json.obj(
      "queryId" := x.queryId,
      "totalBytesProcessed" := x.totalBytesProcessed,
      "cacheHit" := x.cacheHit,
      "sessionInfo" := x.sessionInfo,
      "errors" := x.errors,
      "pageToken" := x.pageToken,
      "jobCreationReason" := x.jobCreationReason,
      "jobComplete" := x.jobComplete,
      "schema" := x.schema,
      "dmlStats" := x.dmlStats,
      "numDmlAffectedRows" := x.numDmlAffectedRows,
      "totalRows" := x.totalRows,
      "kind" := x.kind,
      "jobReference" := x.jobReference,
      "rows" := x.rows,
    )
  }
  implicit val decoder: Decoder[QueryResponse] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("queryId")
      v1 <- c.get[Option[Long]]("totalBytesProcessed")
      v2 <- c.get[Option[Boolean]]("cacheHit")
      v3 <- c.get[Option[SessionInfo]]("sessionInfo")
      v4 <- c.get[Option[List[ErrorProto]]]("errors")
      v5 <- c.get[Option[String]]("pageToken")
      v6 <- c.get[Option[Json]]("jobCreationReason")
      v7 <- c.get[Option[Boolean]]("jobComplete")
      v8 <- c.get[Option[TableSchema]]("schema")
      v9 <- c.get[Option[DmlStatistics]]("dmlStats")
      v10 <- c.get[Option[Long]]("numDmlAffectedRows")
      v11 <- c.get[Option[BigInt]]("totalRows")
      v12 <- c.get[Option[String]]("kind")
      v13 <- c.get[Option[JobReference]]("jobReference")
      v14 <- c.get[Option[List[TableRow]]]("rows")
    } yield QueryResponse(v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, v11, v12, v13, v14)
  }
}
