package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryParameterValueRangeValue(
    end: Option[QueryParameterValue] = None,
    start: Option[QueryParameterValue] = None,
)
object QueryParameterValueRangeValue {
  implicit val encoder: Encoder[
    QueryParameterValueRangeValue
  ] = Encoder.instance(x => Json.obj("end" := x.end, "start" := x.start))
  implicit val decoder: Decoder[
    QueryParameterValueRangeValue
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[QueryParameterValue]]("end")
      v1 <- c.get[Option[QueryParameterValue]]("start")
    } yield QueryParameterValueRangeValue(v0, v1)
  }
}
