package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryParameterValue(
    // [Optional] The array values, if this is an array type.
    arrayValues: Option[List[QueryParameterValue]] = None,
    // [Optional] The range value, if this is a range type.
    rangeValue: Option[QueryParameterValueRangeValue] = None,
    // [Optional] The struct field values, in order of the struct type's declaration.
    structValues: Option[Map[String, QueryParameterValue]] = None,
    // [Optional] The value of this value, if a simple scalar type.
    value: Option[String] = None,
)
object QueryParameterValue {
  implicit val encoder: Encoder[QueryParameterValue] = Encoder.instance { x =>
    Json.obj(
      "arrayValues" := x.arrayValues,
      "rangeValue" := x.rangeValue,
      "structValues" := x.structValues,
      "value" := x.value,
    )
  }
  implicit val decoder: Decoder[QueryParameterValue] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[QueryParameterValue]]]("arrayValues")
      v1 <- c.get[Option[QueryParameterValueRangeValue]]("rangeValue")
      v2 <- c.get[Option[Map[String, QueryParameterValue]]]("structValues")
      v3 <- c.get[Option[String]]("value")
    } yield QueryParameterValue(v0, v1, v2, v3)

  }
}
