package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryParameterTypeStructType(
    // [Optional] Human-oriented description of the field.
    description: Option[String] = None, // [Optional] The name of this field.
    name: Option[String] = None, // [Required] The type of this field.
    `type`: QueryParameterType,
)
object QueryParameterTypeStructType {
  implicit val encoder: Encoder[
    QueryParameterTypeStructType
  ] = Encoder.instance { x =>
    Json.obj(
      "description" := x.description,
      "name" := x.name,
      "type" := x.`type`,
    )
  }
  implicit val decoder: Decoder[
    QueryParameterTypeStructType
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("description")
      v1 <- c.get[Option[String]]("name")
      v2 <- c.get[QueryParameterType]("type")
    } yield QueryParameterTypeStructType(v0, v1, v2)
  }
}
