package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryParameterType(
    // [Optional] The type of the array's elements, if this is an array.
    arrayType: Option[QueryParameterType] = None,
    // [Optional] The element type of the range, if this is a range.
    rangeElementType: Option[QueryParameterType] = None,
    // [Optional] The types of the fields of this struct, in order, if this is a struct.
    structTypes: Option[List[QueryParameterTypeStructType]] = None,
    // [Required] The top level type of this field.
    `type`: String,
)
object QueryParameterType {
  implicit val encoder: Encoder[QueryParameterType] = Encoder.instance { x =>
    Json.obj(
      "arrayType" := x.arrayType,
      "rangeElementType" := x.rangeElementType,
      "structTypes" := x.structTypes,
      "type" := x.`type`,
    )
  }
  implicit val decoder: Decoder[QueryParameterType] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[QueryParameterType]]("arrayType")
      v1 <- c.get[Option[QueryParameterType]]("rangeElementType")
      v2 <- c.get[Option[List[QueryParameterTypeStructType]]]("structTypes")
      v3 <- c.get[String]("type")
    } yield QueryParameterType(v0, v1, v2, v3)

  }
}
