package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class QueryParameter(
    // [Optional] If unset, this is a positional parameter. Otherwise, should be unique within a query.
    name: Option[String] = None, // [Required] The type of this parameter.
    parameterType: QueryParameterType, // [Required] The value of this parameter.
    parameterValue: QueryParameterValue,
)
object QueryParameter {
  implicit val encoder: Encoder[QueryParameter] = Encoder.instance { x =>
    Json.obj(
      "name" := x.name,
      "parameterType" := x.parameterType,
      "parameterValue" :=
        x.parameterValue,
    )
  }
  implicit val decoder: Decoder[QueryParameter] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("name")
      v1 <- c.get[QueryParameterType]("parameterType")
      v2 <- c.get[QueryParameterValue]("parameterValue")
    } yield QueryParameter(v0, v1, v2)
  }
}
