package googleapis.bigquery

import cats.effect.Concurrent
import org.http4s._
import org.http4s.implicits._
import org.http4s.circe._
import org.http4s.client.Client
import io.circe._

class ProjectsClient[F[_]: Concurrent](client: Client[F]) {
  implicit private def entityDecoder[A: Decoder]: EntityDecoder[F, A] = jsonOf[F, A]
  val baseUri = uri"https://bigquery.googleapis.com/bigquery/v2"

  def getServiceAccount(
      // Project ID for which the service account is requested.
      projectId: String
  ): F[Option[GetServiceAccountResponse]] =
    client.expectOption[GetServiceAccountResponse](
      Request[F](
        method = Method.GET,
        uri = baseUri / "projects" / s"${projectId}" / "serviceAccount",
      )
    )

  def list(
  ): F[Option[ProjectList]] =
    client.expectOption[ProjectList](
      Request[F](method = Method.GET, uri = baseUri / "projects")
    )

}
