package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ProjectReference(
    // [Required] ID of the project. Can be either the numeric ID or the assigned ID of the project.
    projectId: String
)
object ProjectReference {
  implicit val encoder: Encoder[ProjectReference] = Encoder.instance { x =>
    Json.obj("projectId" := x.projectId)
  }
  implicit val decoder: Decoder[ProjectReference] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("projectId")
    } yield ProjectReference(v0)
  }
}
