package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ProjectListProject( // A unique reference to this project.
    projectReference: Option[ProjectReference] = None, // A descriptive name for this project.
    friendlyName: Option[String] = None, // An opaque ID of this project.
    id: Option[String] = None, // The numeric ID of this project.
    numericId: Option[BigInt] = None, // The resource type.
    kind: Option[String] = None,
)
object ProjectListProject {
  implicit val encoder: Encoder[ProjectListProject] = Encoder.instance { x =>
    Json.obj(
      "projectReference" := x.projectReference,
      "friendlyName" := x.friendlyName,
      "id" := x.id,
      "numericId" := x.numericId,
      "kind" := x.kind,
    )
  }
  implicit val decoder: Decoder[ProjectListProject] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ProjectReference]]("projectReference")
      v1 <- c.get[Option[String]]("friendlyName")
      v2 <- c.get[Option[String]]("id")
      v3 <- c.get[Option[BigInt]]("numericId")
      v4 <- c.get[Option[String]]("kind")
    } yield ProjectListProject(v0, v1, v2, v3, v4)

  }
}
