package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ProjectList( // A hash of the page of results
    etag: Option[String] = None, // A token to request the next page of results.
    nextPageToken: Option[String] = None, // Projects to which you have at least READ access.
    projects: Option[List[ProjectListProject]] = None, // The type of list.
    kind: Option[String] = None, // The total number of projects in the list.
    totalItems: Option[Int] = None,
)
object ProjectList {
  implicit val encoder: Encoder[ProjectList] = Encoder.instance { x =>
    Json.obj(
      "etag" := x.etag,
      "nextPageToken" := x.nextPageToken,
      "projects" := x.projects,
      "kind" := x.kind,
      "totalItems" := x.totalItems,
    )
  }
  implicit val decoder: Decoder[ProjectList] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("etag")
      v1 <- c.get[Option[String]]("nextPageToken")
      v2 <- c.get[Option[List[ProjectListProject]]]("projects")
      v3 <- c.get[Option[String]]("kind")
      v4 <- c.get[Option[Int]]("totalItems")
    } yield ProjectList(v0, v1, v2, v3, v4)
  }
}
