package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class PrivacyPolicy(
    // Optional. Policy used for aggregation thresholds.
    aggregationThresholdPolicy: Option[AggregationThresholdPolicy] = None
)
object PrivacyPolicy {
  implicit val encoder: Encoder[PrivacyPolicy] = Encoder.instance { x =>
    Json.obj("aggregationThresholdPolicy" := x.aggregationThresholdPolicy)
  }
  implicit val decoder: Decoder[PrivacyPolicy] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[AggregationThresholdPolicy]]("aggregationThresholdPolicy")
    } yield PrivacyPolicy(v0)
  }
}
