package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class PrincipalComponentInfo(
    // The explained_variance is pre-ordered in the descending order to compute the cumulative explained variance ratio.
    cumulativeExplainedVarianceRatio: Option[Double] = None,
    // Explained variance by this principal component, which is simply the eigenvalue.
    explainedVariance: Option[Double] = None,
    // Explained_variance over the total explained variance.
    explainedVarianceRatio: Option[Double] = None,
    // Id of the principal component.
    principalComponentId: Option[Long] = None,
)
object PrincipalComponentInfo {
  implicit val encoder: Encoder[PrincipalComponentInfo] = Encoder.instance { x =>
    Json.obj(
      "cumulativeExplainedVarianceRatio" := x.cumulativeExplainedVarianceRatio,
      "explainedVariance" := x.explainedVariance,
      "explainedVarianceRatio" := x.explainedVarianceRatio,
      "principalComponentId" := x.principalComponentId,
    )
  }
  implicit val decoder: Decoder[
    PrincipalComponentInfo
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Double]]("cumulativeExplainedVarianceRatio")
      v1 <- c.get[Option[Double]]("explainedVariance")
      v2 <- c.get[Option[Double]]("explainedVarianceRatio")
      v3 <- c.get[Option[Long]]("principalComponentId")
    } yield PrincipalComponentInfo(v0, v1, v2, v3)
  }
}
