package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scodec.bits.ByteVector

final case class Policy(
    // Specifies cloud audit logging configuration for this policy.
    auditConfigs: Option[List[AuditConfig]] = None,
    // Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
    bindings: Option[List[Binding]] = None,
    // `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
    etag: Option[ByteVector] = None,
    // Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
    version: Option[Int] = None,
)
object Policy {
  implicit val encoder: Encoder[Policy] = Encoder.instance { x =>
    Json.obj(
      "auditConfigs" := x.auditConfigs,
      "bindings" := x.bindings,
      "etag" := x.etag,
      "version" := x.version,
    )
  }
  implicit val decoder: Decoder[Policy] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[AuditConfig]]]("auditConfigs")
      v1 <- c.get[Option[List[Binding]]]("bindings")
      v2 <- c.get[Option[ByteVector]]("etag")
      v3 <- c.get[Option[Int]]("version")
    } yield Policy(v0, v1, v2, v3)
  }
}
