package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ParquetOptions(
    // [Optional] Indicates whether to use schema inference specifically for Parquet LIST logical type.
    enableListInference: Option[Boolean] = None,
    // [Optional] Indicates whether to infer Parquet ENUM logical type as STRING instead of BYTES by default.
    enumAsString: Option[Boolean] = None,
)
object ParquetOptions {
  implicit val encoder: Encoder[ParquetOptions] = Encoder.instance { x =>
    Json.obj(
      "enableListInference" := x.enableListInference,
      "enumAsString" := x.enumAsString,
    )
  }
  implicit val decoder: Decoder[ParquetOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Boolean]]("enableListInference")
      v1 <- c.get[Option[Boolean]]("enumAsString")
    } yield ParquetOptions(v0, v1)
  }
}
