package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class MultiClassClassificationMetrics(
    // Aggregate classification metrics.
    aggregateClassificationMetrics: Option[AggregateClassificationMetrics] = None,
    // Confusion matrix at different thresholds.
    confusionMatrixList: Option[List[ConfusionMatrix]] = None,
)
object MultiClassClassificationMetrics {
  implicit val encoder: Encoder[
    MultiClassClassificationMetrics
  ] = Encoder.instance { x =>
    Json.obj(
      "aggregateClassificationMetrics" := x.aggregateClassificationMetrics,
      "confusionMatrixList" := x.confusionMatrixList,
    )
  }
  implicit val decoder: Decoder[
    MultiClassClassificationMetrics
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[AggregateClassificationMetrics]]("aggregateClassificationMetrics")
      v1 <- c.get[Option[List[ConfusionMatrix]]]("confusionMatrixList")
    } yield MultiClassClassificationMetrics(v0, v1)
  }
}
