package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ModelReference(
    // Required. The ID of the dataset containing this model.
    datasetId: Option[String] = None,
    // Required. The ID of the model. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 1,024 characters.
    modelId: Option[String] = None,
    // Required. The ID of the project containing this model.
    projectId: Option[String] = None,
)
object ModelReference {
  implicit val encoder: Encoder[ModelReference] = Encoder.instance { x =>
    Json.obj(
      "datasetId" := x.datasetId,
      "modelId" := x.modelId,
      "projectId" := x.projectId,
    )
  }
  implicit val decoder: Decoder[ModelReference] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("datasetId")
      v1 <- c.get[Option[String]]("modelId")
      v2 <- c.get[Option[String]]("projectId")
    } yield ModelReference(v0, v1, v2)
  }
}
