package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ModelDefinitionModelOptions(
    labels: Option[List[String]] = None,
    lossType: Option[String] = None,
    modelType: Option[String] = None,
)
object ModelDefinitionModelOptions {
  implicit val encoder: Encoder[
    ModelDefinitionModelOptions
  ] = Encoder.instance { x =>
    Json.obj(
      "labels" := x.labels,
      "lossType" := x.lossType,
      "modelType" := x.modelType,
    )
  }
  implicit val decoder: Decoder[
    ModelDefinitionModelOptions
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[String]]]("labels")
      v1 <- c.get[Option[String]]("lossType")
      v2 <- c.get[Option[String]]("modelType")
    } yield ModelDefinitionModelOptions(v0, v1, v2)
  }
}
