package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ModelDefinition(
    // [Output-only, Beta] Model options used for the first training run. These options are immutable for subsequent training runs. Default values are used for any options not specified in the input query.
    modelOptions: Option[ModelDefinitionModelOptions] = None,
    // [Output-only, Beta] Information about ml training runs, each training run comprises of multiple iterations and there may be multiple training runs for the model if warm start is used or if a user decides to continue a previously cancelled query.
    trainingRuns: Option[List[BqmlTrainingRun]] = None,
)
object ModelDefinition {
  implicit val encoder: Encoder[ModelDefinition] = Encoder.instance { x =>
    Json.obj("modelOptions" := x.modelOptions, "trainingRuns" := x.trainingRuns)
  }
  implicit val decoder: Decoder[ModelDefinition] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ModelDefinitionModelOptions]]("modelOptions")
      v1 <- c.get[Option[List[BqmlTrainingRun]]]("trainingRuns")
    } yield ModelDefinition(v0, v1)
  }
}
