package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class Model(
    // Custom encryption configuration (e.g., Cloud KMS keys). This shows the encryption configuration of the model data while stored in BigQuery storage. This field can be used with PatchModel to update encryption key for an already encrypted model.
    encryptionConfiguration: Option[EncryptionConfiguration] = None,
    // Output only. A hash of this resource.
    etag: Option[String] = None,
    // Output only. The time when this model was last modified, in millisecs since the epoch.
    lastModifiedTime: Option[FiniteDuration] = None,
    // Output only. Trials of a [hyperparameter tuning](/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) model sorted by trial_id.
    hparamTrials: Option[List[HparamTuningTrial]] = None,
    // Optional. The time when this model expires, in milliseconds since the epoch. If not present, the model will persist indefinitely. Expired models will be deleted and their storage reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to set a default expirationTime on newly created models.
    expirationTime: Option[FiniteDuration] = None,
    // Output only. The geographic location where the model resides. This value is inherited from the dataset.
    location: Option[String] = None,
    // Required. Unique identifier for this model.
    modelReference: Option[ModelReference] = None,
    // The best trial_id across all training runs.
    bestTrialId: Option[Long] = None,
    // Output only. This field will be populated if a TRANSFORM clause was used to train a model. TRANSFORM clause (if used) takes feature_columns as input and outputs transform_columns. transform_columns then are used to train the model.
    transformColumns: Option[List[TransformColumn]] = None,
    // Optional. A user-friendly description of this model.
    description: Option[String] = None,
    // Output only. All hyperparameter search spaces in this model.
    hparamSearchSpaces: Option[HparamSearchSpaces] = None,
    // Optional. A descriptive name for this model.
    friendlyName: Option[String] = None,
    // Output only. Label columns that were used to train this model. The output of the model will have a "predicted_" prefix to these columns.
    labelColumns: Option[List[StandardSqlField]] = None,
    // Output only. Type of the model resource.
    modelType: Option[ModelModelType] = None,
    // Output only. Input feature columns for the model inference. If the model is trained with TRANSFORM clause, these are the input of the TRANSFORM clause.
    featureColumns: Option[List[StandardSqlField]] = None,
    // The labels associated with this model. You can use these to organize and group your models. Label keys and values can be no longer than 63 characters, can only contain lowercase letters, numeric characters, underscores and dashes. International characters are allowed. Label values are optional. Label keys must start with a letter and each label in the list must have a different key.
    labels: Option[Map[String, String]] = None,
    // Output only. For single-objective [hyperparameter tuning](/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it only contains the best trial. For multi-objective [hyperparameter tuning](/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it contains all Pareto optimal trials sorted by trial_id.
    optimalTrialIds: Option[List[Long]] = None, // Output only. Remote model info
    remoteModelInfo: Option[RemoteModelInfo] = None,
    // Information for all training runs in increasing order of start_time.
    trainingRuns: Option[List[TrainingRun]] = None,
    // Output only. The time when this model was created, in millisecs since the epoch.
    creationTime: Option[FiniteDuration] = None,
    // Output only. The default trial_id to use in TVFs when the trial_id is not passed in. For single-objective [hyperparameter tuning](/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the best trial ID. For multi-objective [hyperparameter tuning](/bigquery-ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the smallest trial ID among all Pareto optimal trials.
    defaultTrialId: Option[Long] = None,
)
object Model {
  implicit val encoder: Encoder[Model] = Encoder.instance { x =>
    Json.obj(
      "encryptionConfiguration" := x.encryptionConfiguration,
      "etag" := x.etag,
      "lastModifiedTime" := x.lastModifiedTime,
      "hparamTrials" := x.hparamTrials,
      "expirationTime" := x.expirationTime,
      "location" := x.location,
      "modelReference" := x.modelReference,
      "bestTrialId" := x.bestTrialId,
      "transformColumns" := x.transformColumns,
      "description" := x.description,
      "hparamSearchSpaces" := x.hparamSearchSpaces,
      "friendlyName"
        := x.friendlyName,
      "labelColumns" := x.labelColumns,
      "modelType" := x.modelType,
      "featureColumns" := x.featureColumns,
      "labels" := x.labels,
      "optimalTrialIds" := x.optimalTrialIds,
      "remoteModelInfo" := x.remoteModelInfo,
      "trainingRuns" := x.trainingRuns,
      "creationTime" := x.creationTime,
      "defaultTrialId" := x.defaultTrialId,
    )
  }
  implicit val decoder: Decoder[Model] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[EncryptionConfiguration]]("encryptionConfiguration")
      v1 <- c.get[Option[String]]("etag")
      v2 <- c.get[Option[FiniteDuration]]("lastModifiedTime")
      v3 <- c.get[Option[List[HparamTuningTrial]]]("hparamTrials")
      v4 <- c.get[Option[FiniteDuration]]("expirationTime")
      v5 <- c.get[Option[String]]("location")
      v6 <- c.get[Option[ModelReference]]("modelReference")
      v7 <- c.get[Option[Long]]("bestTrialId")
      v8 <- c.get[Option[List[TransformColumn]]]("transformColumns")
      v9 <- c.get[Option[String]]("description")
      v10 <- c.get[Option[HparamSearchSpaces]]("hparamSearchSpaces")
      v11 <- c.get[Option[String]]("friendlyName")
      v12 <- c.get[Option[List[StandardSqlField]]]("labelColumns")
      v13 <- c.get[Option[ModelModelType]]("modelType")
      v14 <- c.get[Option[List[StandardSqlField]]]("featureColumns")
      v15 <- c.get[Option[Map[String, String]]]("labels")
      v16 <- c.get[Option[List[Long]]]("optimalTrialIds")
      v17 <- c.get[Option[RemoteModelInfo]]("remoteModelInfo")
      v18 <- c.get[Option[List[TrainingRun]]]("trainingRuns")
      v19 <- c.get[Option[FiniteDuration]]("creationTime")
      v20 <- c.get[Option[Long]]("defaultTrialId")
    } yield Model(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
    )
  }
}
