package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class MlStatistics( // Results for all completed iterations.
    iterationResults: Option[List[IterationResult]] =
      None, // Maximum number of iterations specified as max_iterations in the 'CREATE MODEL' query. The actual number of iterations may be less than this number due to early stop.
    maxIterations: Option[Long] = None,
)
object MlStatistics {
  implicit val encoder: Encoder[MlStatistics] = Encoder.instance { x =>
    Json.obj(
      "iterationResults" := x.iterationResults,
      "maxIterations" := x.maxIterations,
    )
  }
  implicit val decoder: Decoder[MlStatistics] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[IterationResult]]]("iterationResults")
      v1 <- c.get[Option[Long]]("maxIterations")
    } yield MlStatistics(v0, v1)
  }
}
