package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scodec.bits.ByteVector
import scala.concurrent.duration.FiniteDuration

final case class MaterializedViewDefinition(
    // [Required] A query whose result is persisted.
    query: String,
    // [Optional] Allow non incremental materialized view definition. The default value is "false".
    allowNonIncrementalDefinition: Option[Boolean] = None,
    // [Optional] [TrustedTester] Enable automatic refresh of the materialized view when the base table is updated. The default value is "true".
    enableRefresh: Option[Boolean] = None,
    // [Optional] [TrustedTester] The maximum frequency at which this materialized view will be refreshed. The default value is "1800000" (30 minutes).
    refreshIntervalMs: Option[Long] = None,
    // [Output-only] [TrustedTester] The time when this materialized view was last modified, in milliseconds since the epoch.
    lastRefreshTime: Option[FiniteDuration] = None,
    // [Optional] Max staleness of data that could be returned when materizlized view is queried (formatted as Google SQL Interval type).
    maxStaleness: Option[ByteVector] = None,
)
object MaterializedViewDefinition {
  implicit val encoder: Encoder[
    MaterializedViewDefinition
  ] = Encoder.instance { x =>
    Json.obj(
      "query" := x.query,
      "allowNonIncrementalDefinition" := x.allowNonIncrementalDefinition,
      "enableRefresh" := x.enableRefresh,
      "refreshIntervalMs" := x.refreshIntervalMs,
      "lastRefreshTime" := x.lastRefreshTime,
      "maxStaleness" := x.maxStaleness,
    )
  }
  implicit val decoder: Decoder[
    MaterializedViewDefinition
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[String]("query")
      v1 <- c.get[Option[Boolean]]("allowNonIncrementalDefinition")
      v2 <- c.get[Option[Boolean]]("enableRefresh")
      v3 <- c.get[Option[Long]]("refreshIntervalMs")
      v4 <- c.get[Option[FiniteDuration]]("lastRefreshTime")
      v5 <- c.get[Option[ByteVector]]("maxStaleness")
    } yield MaterializedViewDefinition(v0, v1, v2, v3, v4, v5)
  }
}
