package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class LocationMetadata(
    // The legacy BigQuery location ID, e.g. “EU” for the “europe” location. This is for any API consumers that need the legacy “US” and “EU” locations.
    legacyLocationId: Option[String] = None
)
object LocationMetadata {
  implicit val encoder: Encoder[LocationMetadata] = Encoder.instance { x =>
    Json.obj("legacyLocationId" := x.legacyLocationId)
  }
  implicit val decoder: Decoder[LocationMetadata] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("legacyLocationId")
    } yield LocationMetadata(v0)
  }
}
