package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ListRowAccessPoliciesResponse(
    // A token to request the next page of results.
    nextPageToken: Option[String] = None,
    // Row access policies on the requested table.
    rowAccessPolicies: Option[List[RowAccessPolicy]] = None,
)
object ListRowAccessPoliciesResponse {
  implicit val encoder: Encoder[
    ListRowAccessPoliciesResponse
  ] = Encoder.instance { x =>
    Json.obj(
      "nextPageToken" := x.nextPageToken,
      "rowAccessPolicies" := x.rowAccessPolicies,
    )
  }
  implicit val decoder: Decoder[
    ListRowAccessPoliciesResponse
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("nextPageToken")
      v1 <- c.get[Option[List[RowAccessPolicy]]]("rowAccessPolicies")
    } yield ListRowAccessPoliciesResponse(v0, v1)
  }
}
