package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ListRoutinesResponse(
    // A token to request the next page of results.
    nextPageToken: Option[String] = None,
    // Routines in the requested dataset. Unless read_mask is set in the request, only the following fields are populated: etag, project_id, dataset_id, routine_id, routine_type, creation_time, last_modified_time, language, and remote_function_options.
    routines: Option[List[Routine]] = None,
)
object ListRoutinesResponse {
  implicit val encoder: Encoder[ListRoutinesResponse] = Encoder.instance { x =>
    Json.obj("nextPageToken" := x.nextPageToken, "routines" := x.routines)
  }
  implicit val decoder: Decoder[ListRoutinesResponse] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("nextPageToken")
      v1 <- c.get[Option[List[Routine]]]("routines")
    } yield ListRoutinesResponse(v0, v1)

  }
}
