package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class ListModelsResponse(
    // Models in the requested dataset. Only the following fields are populated: model_reference, model_type, creation_time, last_modified_time and labels.
    models: Option[List[Model]] = None,
    // A token to request the next page of results.
    nextPageToken: Option[String] = None,
)
object ListModelsResponse {
  implicit val encoder: Encoder[ListModelsResponse] = Encoder.instance { x =>
    Json.obj("models" := x.models, "nextPageToken" := x.nextPageToken)
  }
  implicit val decoder: Decoder[ListModelsResponse] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Model]]]("models")
      v1 <- c.get[Option[String]]("nextPageToken")
    } yield ListModelsResponse(v0, v1)

  }
}
