package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JsonOptions(
    // [Optional] The character encoding of the data. The supported values are UTF-8, UTF-16BE, UTF-16LE, UTF-32BE, and UTF-32LE. The default value is UTF-8.
    encoding: Option[String] = None
)
object JsonOptions {
  implicit val encoder: Encoder[JsonOptions] = Encoder.instance { x =>
    Json.obj("encoding" := x.encoding)
  }
  implicit val decoder: Decoder[JsonOptions] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("encoding")
    } yield JsonOptions(v0)
  }
}
