package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobStatus(
    // [Output-only] Final error result of the job. If present, indicates that the job has completed and was unsuccessful.
    errorResult: Option[ErrorProto] = None,
    // [Output-only] The first errors encountered during the running of the job. The final message includes the number of errors that caused the process to stop. Errors here do not necessarily mean that the job has completed or was unsuccessful.
    errors: Option[List[ErrorProto]] = None,
    // [Output-only] Running state of the job.
    state: Option[String] = None,
)
object JobStatus {
  implicit val encoder: Encoder[JobStatus] = Encoder.instance { x =>
    Json.obj(
      "errorResult" := x.errorResult,
      "errors" := x.errors,
      "state" := x.state,
    )
  }
  implicit val decoder: Decoder[JobStatus] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[ErrorProto]]("errorResult")
      v1 <- c.get[Option[List[ErrorProto]]]("errors")
      v2 <- c.get[Option[String]]("state")
    } yield JobStatus(v0, v1, v2)
  }
}
