package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class JobStatisticsReservationUsage(
    // [Output-only] Reservation name or "unreserved" for on-demand resources usage.
    name: Option[String] = None,
    // [Output-only] Slot-milliseconds the job spent in the given reservation.
    slotMs: Option[FiniteDuration] = None,
)
object JobStatisticsReservationUsage {
  implicit val encoder: Encoder[
    JobStatisticsReservationUsage
  ] = Encoder.instance(x => Json.obj("name" := x.name, "slotMs" := x.slotMs))
  implicit val decoder: Decoder[
    JobStatisticsReservationUsage
  ] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[String]]("name")
      v1 <- c.get[Option[FiniteDuration]]("slotMs")
    } yield JobStatisticsReservationUsage(v0, v1)
  }
}
