package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobStatistics5(
    // [Output-only] Number of logical bytes copied to the destination table.
    copiedLogicalBytes: Option[Long] = None,
    // [Output-only] Number of rows copied to the destination table.
    copiedRows: Option[Long] = None,
)
object JobStatistics5 {
  implicit val encoder: Encoder[JobStatistics5] = Encoder.instance { x =>
    Json.obj(
      "copiedLogicalBytes" := x.copiedLogicalBytes,
      "copiedRows" := x.copiedRows,
    )
  }
  implicit val decoder: Decoder[JobStatistics5] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[Long]]("copiedLogicalBytes")
      v1 <- c.get[Option[Long]]("copiedRows")
    } yield JobStatistics5(v0, v1)
  }
}
