package googleapis.bigquery

import io.circe._
import io.circe.syntax._

final case class JobStatistics4(
    // [Output-only] Number of files per destination URI or URI pattern specified in the extract configuration. These values will be in the same order as the URIs specified in the 'destinationUris' field.
    destinationUriFileCounts: Option[List[Long]] = None,
    // [Output-only] Number of user bytes extracted into the result. This is the byte count as computed by BigQuery for billing purposes.
    inputBytes: Option[Long] = None,
)
object JobStatistics4 {
  implicit val encoder: Encoder[JobStatistics4] = Encoder.instance { x =>
    Json.obj(
      "destinationUriFileCounts" := x.destinationUriFileCounts,
      "inputBytes" :=
        x.inputBytes,
    )
  }
  implicit val decoder: Decoder[JobStatistics4] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[List[Long]]]("destinationUriFileCounts")
      v1 <- c.get[Option[Long]]("inputBytes")
    } yield JobStatistics4(v0, v1)
  }
}
