package googleapis.bigquery

import JsonInstances._
import io.circe._
import io.circe.syntax._
import scala.concurrent.duration.FiniteDuration

final case class JobStatistics2(
    // [Output only] The DDL target dataset. Present only for CREATE/ALTER/DROP/UNDROP SCHEMA queries.
    ddlTargetDataset: Option[DatasetReference] = None,
    // The DDL target routine. Present only for CREATE/DROP FUNCTION/PROCEDURE queries.
    ddlTargetRoutine: Option[RoutineReference] = None,
    // [Output only] Statistics of a Spark procedure job.
    sparkStatistics: Option[SparkStatistics] = None,
    // [Output only] Total bytes processed for the job.
    totalBytesProcessed: Option[Long] = None,
    // [Output only] [Preview] The number of row access policies affected by a DDL statement. Present only for DROP ALL ROW ACCESS POLICIES queries.
    ddlAffectedRowAccessPolicyCount: Option[Long] = None,
    // The type of query statement, if valid. Possible values (new values might be added in the future): "SELECT": SELECT query. "INSERT": INSERT query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "UPDATE": UPDATE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "DELETE": DELETE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "MERGE": MERGE query; see https://cloud.google.com/bigquery/docs/reference/standard-sql/data-manipulation-language. "ALTER_TABLE": ALTER TABLE query. "ALTER_VIEW": ALTER VIEW query. "ASSERT": ASSERT condition AS 'description'. "CREATE_FUNCTION": CREATE FUNCTION query. "CREATE_MODEL": CREATE [OR REPLACE] MODEL ... AS SELECT ... . "CREATE_PROCEDURE": CREATE PROCEDURE query. "CREATE_TABLE": CREATE [OR REPLACE] TABLE without AS SELECT. "CREATE_TABLE_AS_SELECT": CREATE [OR REPLACE] TABLE ... AS SELECT ... . "CREATE_VIEW": CREATE [OR REPLACE] VIEW ... AS SELECT ... . "DROP_FUNCTION" : DROP FUNCTION query. "DROP_PROCEDURE": DROP PROCEDURE query. "DROP_TABLE": DROP TABLE query. "DROP_VIEW": DROP VIEW query.
    statementType: Option[String] = None,
    // [Output only] Whether the query result was fetched from the query cache.
    cacheHit: Option[Boolean] = None,
    // [Output only] Describes execution plan for the query.
    queryPlan: Option[List[ExplainQueryStage]] = None,
    // [Output only] Referenced routines (persistent user-defined functions and stored procedures) for the job.
    referencedRoutines: Option[List[RoutineReference]] = None,
    // [Output only] [Preview] The DDL target row access policy. Present only for CREATE/DROP ROW ACCESS POLICY queries.
    ddlTargetRowAccessPolicy: Option[RowAccessPolicyReference] = None,
    // [Output only, Beta] Deprecated; do not use.
    modelTrainingCurrentIteration: Option[Int] = None,
    // [Output only] Billing tier for the job.
    billingTier: Option[Int] = None,
    // BI Engine specific Statistics. [Output only] BI Engine specific Statistics.
    biEngineStatistics: Option[BiEngineStatistics] = None,
    // [Output only] Job resource usage breakdown by reservation.
    reservationUsage: Option[List[JobStatistics2ReservationUsage]] = None,
    // [Output only] The schema of the results. Present only for successful dry run of non-legacy SQL queries.
    schema: Option[TableSchema] = None,
    // [Output only] Referenced tables for the job. Queries that reference more than 50 tables will not have a complete list.
    referencedTables: Option[List[TableReference]] = None,
    // [Output only] Detailed statistics for DML statements Present only for DML statements INSERT, UPDATE, DELETE or TRUNCATE.
    dmlStats: Option[DmlStatistics] = None,
    // [Output only] The number of rows affected by a DML statement. Present only for DML statements INSERT, UPDATE or DELETE.
    numDmlAffectedRows: Option[Long] = None,
    // [Output only] Total bytes billed for the job.
    totalBytesBilled: Option[Long] = None,
    // [Output only] Slot-milliseconds for the job.
    totalSlotMs: Option[FiniteDuration] = None,
    // [Output only] The original estimate of bytes processed for the job.
    estimatedBytesProcessed: Option[Long] = None,
    // [Output only] [Beta] Describes a timeline of job execution.
    timeline: Option[List[QueryTimelineSample]] = None,
    // [Output only] Statistics of a BigQuery ML training job.
    mlStatistics: Option[MlStatistics] = None,
    // [Output only, Beta] Information about create model query job progress.
    modelTraining: Option[BigQueryModelTraining] = None,
    // [Output-only] Total bytes transferred for cross-cloud queries such as Cross Cloud Transfer and CREATE TABLE AS SELECT (CTAS).
    transferredBytes: Option[Long] = None,
    // [Output only] For dry-run jobs, totalBytesProcessed is an estimate and this field specifies the accuracy of the estimate. Possible values can be: UNKNOWN: accuracy of the estimate is unknown. PRECISE: estimate is precise. LOWER_BOUND: estimate is lower bound of what the query would cost. UPPER_BOUND: estimate is upper bound of what the query would cost.
    totalBytesProcessedAccuracy: Option[String] = None,
    // [Output only, Beta] Deprecated; do not use.
    modelTrainingExpectedTotalIteration: Option[Long] = None,
    // The DDL operation performed, possibly dependent on the pre-existence of the DDL target. Possible values (new values might be added in the future): "CREATE": The query created the DDL target. "SKIP": No-op. Example cases: the query is CREATE TABLE IF NOT EXISTS while the table already exists, or the query is DROP TABLE IF EXISTS while the table does not exist. "REPLACE": The query replaced the DDL target. Example case: the query is CREATE OR REPLACE TABLE, and the table already exists. "DROP": The query deleted the DDL target.
    ddlOperationPerformed: Option[String] = None,
    // [Output only] Total number of partitions processed from all partitioned tables referenced in the job.
    totalPartitionsProcessed: Option[Long] = None,
    // [Output only] Search query specific statistics.
    searchStatistics: Option[SearchStatistics] = None,
    // Standard SQL only: list of undeclared query parameters detected during a dry run validation.
    undeclaredQueryParameters: Option[List[QueryParameter]] = None,
    // [Output only] The DDL target table. Present only for CREATE/DROP TABLE/VIEW and DROP ALL ROW ACCESS POLICIES queries.
    ddlTargetTable: Option[TableReference] = None,
    // [Output only] The DDL destination table. Present only for ALTER TABLE RENAME TO queries. Note that ddl_target_table is used just for its type information.
    ddlDestinationTable: Option[TableReference] = None,
)
object JobStatistics2 {
  implicit val encoder: Encoder[JobStatistics2] = Encoder.instance { x =>
    Json.obj(
      "ddlTargetDataset" := x.ddlTargetDataset,
      "ddlTargetRoutine" := x.ddlTargetRoutine,
      "sparkStatistics" := x.sparkStatistics,
      "totalBytesProcessed" := x.totalBytesProcessed,
      "ddlAffectedRowAccessPolicyCount" := x.ddlAffectedRowAccessPolicyCount,
      "statementType" := x.statementType,
      "cacheHit" := x.cacheHit,
      "queryPlan"
        := x.queryPlan,
      "referencedRoutines" := x.referencedRoutines,
      "ddlTargetRowAccessPolicy" := x.ddlTargetRowAccessPolicy,
      "modelTrainingCurrentIteration" := x.modelTrainingCurrentIteration,
      "billingTier" := x.billingTier,
      "biEngineStatistics" := x.biEngineStatistics,
      "reservationUsage" := x.reservationUsage,
      "schema" :=
        x.schema,
      "referencedTables" := x.referencedTables,
      "dmlStats" := x.dmlStats,
      "numDmlAffectedRows" := x.numDmlAffectedRows,
      "totalBytesBilled"
        := x.totalBytesBilled,
      "totalSlotMs" := x.totalSlotMs,
      "estimatedBytesProcessed" := x.estimatedBytesProcessed,
      "timeline" := x.timeline,
      "mlStatistics" := x.mlStatistics,
      "modelTraining" := x.modelTraining,
      "transferredBytes" := x.transferredBytes,
      "totalBytesProcessedAccuracy" := x.totalBytesProcessedAccuracy,
      "modelTrainingExpectedTotalIteration" := x.modelTrainingExpectedTotalIteration,
      "ddlOperationPerformed" := x.ddlOperationPerformed,
      "totalPartitionsProcessed" := x.totalPartitionsProcessed,
      "searchStatistics" := x.searchStatistics,
      "undeclaredQueryParameters" := x.undeclaredQueryParameters,
      "ddlTargetTable" := x.ddlTargetTable,
      "ddlDestinationTable" := x.ddlDestinationTable,
    )
  }
  implicit val decoder: Decoder[JobStatistics2] = Decoder.instance { c =>
    for {
      v0 <- c.get[Option[DatasetReference]]("ddlTargetDataset")
      v1 <- c.get[Option[RoutineReference]]("ddlTargetRoutine")
      v2 <- c.get[Option[SparkStatistics]]("sparkStatistics")
      v3 <- c.get[Option[Long]]("totalBytesProcessed")
      v4 <- c.get[Option[Long]]("ddlAffectedRowAccessPolicyCount")
      v5 <- c.get[Option[String]]("statementType")
      v6 <- c.get[Option[Boolean]]("cacheHit")
      v7 <- c.get[Option[List[ExplainQueryStage]]]("queryPlan")
      v8 <- c.get[Option[List[RoutineReference]]]("referencedRoutines")
      v9 <- c.get[Option[RowAccessPolicyReference]]("ddlTargetRowAccessPolicy")
      v10 <- c.get[Option[Int]]("modelTrainingCurrentIteration")
      v11 <- c.get[Option[Int]]("billingTier")
      v12 <- c.get[Option[BiEngineStatistics]]("biEngineStatistics")
      v13 <- c.get[Option[List[JobStatistics2ReservationUsage]]]("reservationUsage")
      v14 <- c.get[Option[TableSchema]]("schema")
      v15 <- c.get[Option[List[TableReference]]]("referencedTables")
      v16 <- c.get[Option[DmlStatistics]]("dmlStats")
      v17 <- c.get[Option[Long]]("numDmlAffectedRows")
      v18 <- c.get[Option[Long]]("totalBytesBilled")
      v19 <- c.get[Option[FiniteDuration]]("totalSlotMs")
      v20 <- c.get[Option[Long]]("estimatedBytesProcessed")
      v21 <- c.get[Option[List[QueryTimelineSample]]]("timeline")
      v22 <- c.get[Option[MlStatistics]]("mlStatistics")
      v23 <- c.get[Option[BigQueryModelTraining]]("modelTraining")
      v24 <- c.get[Option[Long]]("transferredBytes")
      v25 <- c.get[Option[String]]("totalBytesProcessedAccuracy")
      v26 <- c.get[Option[Long]]("modelTrainingExpectedTotalIteration")
      v27 <- c.get[Option[String]]("ddlOperationPerformed")
      v28 <- c.get[Option[Long]]("totalPartitionsProcessed")
      v29 <- c.get[Option[SearchStatistics]]("searchStatistics")
      v30 <- c.get[Option[List[QueryParameter]]]("undeclaredQueryParameters")
      v31 <- c.get[Option[TableReference]]("ddlTargetTable")
      v32 <- c.get[Option[TableReference]]("ddlDestinationTable")
    } yield JobStatistics2(
      v0,
      v1,
      v2,
      v3,
      v4,
      v5,
      v6,
      v7,
      v8,
      v9,
      v10,
      v11,
      v12,
      v13,
      v14,
      v15,
      v16,
      v17,
      v18,
      v19,
      v20,
      v21,
      v22,
      v23,
      v24,
      v25,
      v26,
      v27,
      v28,
      v29,
      v30,
      v31,
      v32,
    )
  }
}
